<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVendorTable extends Migration {

	public function up()
	{
		Schema::create('vendor', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('address');
			$table->string('city');
			$table->string('state');
			$table->string('phone1');
			$table->string('phone2');
			$table->string('website');
			$table->boolean('is_supplier');
			$table->boolean('is_manufacturer');
			$table->boolean('status');
			$table->integer('template');
			$table->integer('format');
			$table->integer('payment_term');
			$table->boolean('ltr');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('vendor');
	}
}