<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductTable extends Migration {

	public function up()
	{
		Schema::create('product', function(Blueprint $table) {
			$table->string('description');
			$table->increments('id');
			$table->string('sku');
			$table->string('upc');
			$table->string('mpn');
			$table->integer('buyer_id');
			$table->integer('brand_id');
			$table->integer('category_id');
			$table->integer('label_id');
			$table->float('min_adv_price');
			$table->float('max_shipping_cost');
			$table->float('vendor_cost');
			$table->float('height');
			$table->float('length');
			$table->float('width');
			$table->integer('pound');
			$table->integer('ounce');
			$table->json('galleries');
			$table->integer('default_vendor_product_id');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('product');
	}
}