<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id', true);
			$table->timestamps();
			$table->string('name', 255);
			$table->string('email', 255)->unique();
			$table->string('phone', 150);
			$table->string('address', 255);
			$table->integer('role')->unique();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}