<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('words', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('translations', function(Blueprint $table) {
			$table->foreign('original_word_id')->references('id')->on('words')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('translations', function(Blueprint $table) {
			$table->foreign('translated_word_id')->references('id')->on('words')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('words', function(Blueprint $table) {
			$table->dropForeign('words_language_id_foreign');
		});
		Schema::table('translations', function(Blueprint $table) {
			$table->dropForeign('translations_original_word_id_foreign');
		});
		Schema::table('translations', function(Blueprint $table) {
			$table->dropForeign('translations_translated_word_id_foreign');
		});
	}
}