<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateBasketsTable extends Migration {

	public function up()
	{
		Schema::create('baskets', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('customer_id')->unique();
			$table->string('contact_id');
			$table->bigInteger('booking_id');
			$table->string('tour_id');
			$table->string('currency_code');
			$table->integer('total_passenger_count');
			$table->bigInteger('deposit_amount');
			$table->string('promo_code');
			$table->string('reservation_id');
			$table->longText('sugati_response');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('baskets');
	}
}