<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRequestsTable extends Migration {

	public function up()
	{
		Schema::create('requests', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('client_id')->unsigned();
			$table->string('name', 255);
			$table->string('age', 255);
			$table->string('blood_type', 10);
			$table->string('quantity', 10);
			$table->string('hospital_address', 255);
			$table->string('hospital_name');
			$table->string('mobile', 255);
		});
	}

	public function down()
	{
		Schema::drop('requests');
	}
}