<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCategoriesTable extends Migration {

	public function up()
	{
		Schema::create('categories', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id');
			$table->integer('parent_id');
			$table->string('name', 64);
			$table->text('description');
			$table->string('image', 64);
			$table->string('slug', 32);
			$table->integer('status')->default('1');
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('categories');
	}
}