<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomerTable extends Migration {

	public function up()
	{
		Schema::create('customer', function(Blueprint $table) {
			$table->increments('id');
			$table->string('first_name', 32);
			$table->string('last_name', 64);
			$table->integer('phone_num');
			$table->string('email');
			$table->integer('status')->default('1');
			$table->timestamps();
			$table->string('username', 32);
			$table->string('email_verified_at', 255);
			$table->string('password', 32);
			$table->text('address');
			$table->text('receiver_address');
		});
	}

	public function down()
	{
		Schema::drop('customer');
	}
}