<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePurchasesTable extends Migration {

	public function up()
	{
		Schema::create('purchases', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('user_id');
			$table->string('chalan_no', 64);
			$table->integer('supplier_id')->unsigned();
			$table->integer('product_id');
			$table->decimal('discount', 8,2)->nullable();
			$table->decimal('extra_cost', 8,2)->nullable();
			$table->decimal('total', 8,2);
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('purchases');
	}
}