<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('vessels', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('vessels', function(Blueprint $table) {
			$table->foreign('vessel_model')->references('id')->on('vessel_models')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('vessel_cabins_counts', function(Blueprint $table) {
			$table->foreign('cabin_type_id')->references('id')->on('cabin_types')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('vessel_cabins_counts', function(Blueprint $table) {
			$table->foreign('seat_calss')->references('id')->on('seat_calsses')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('vessel_cabins_counts', function(Blueprint $table) {
			$table->foreign('vessel_id')->references('id')->on('vessels')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('liens', function(Blueprint $table) {
			$table->foreign('vessel_id')->references('id')->on('vessels')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('vessel_routes', function(Blueprint $table) {
			$table->foreign('from')->references('id')->on('ports')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('vessel_routes', function(Blueprint $table) {
			$table->foreign('to')->references('id')->on('ports')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->foreign('seat_calss')->references('id')->on('seat_calsses')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->foreign('ticket_class')->references('id')->on('tickets_classes')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->foreign('trip_id')->references('id')->on('trips')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('customers', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('no action');
		});
	}

	public function down()
	{
		Schema::table('vessels', function(Blueprint $table) {
			$table->dropForeign('vessels_created_by_foreign');
		});
		Schema::table('vessels', function(Blueprint $table) {
			$table->dropForeign('vessels_vessel_model_foreign');
		});
		Schema::table('vessel_cabins_counts', function(Blueprint $table) {
			$table->dropForeign('vessel_cabins_counts_cabin_type_id_foreign');
		});
		Schema::table('vessel_cabins_counts', function(Blueprint $table) {
			$table->dropForeign('vessel_cabins_counts_seat_calss_foreign');
		});
		Schema::table('vessel_cabins_counts', function(Blueprint $table) {
			$table->dropForeign('vessel_cabins_counts_vessel_id_foreign');
		});
		Schema::table('liens', function(Blueprint $table) {
			$table->dropForeign('liens_vessel_id_foreign');
		});
		Schema::table('vessel_routes', function(Blueprint $table) {
			$table->dropForeign('vessel_routes_from_foreign');
		});
		Schema::table('vessel_routes', function(Blueprint $table) {
			$table->dropForeign('vessel_routes_to_foreign');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->dropForeign('tickets_seat_calss_foreign');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->dropForeign('tickets_ticket_class_foreign');
		});
		Schema::table('tickets', function(Blueprint $table) {
			$table->dropForeign('tickets_trip_id_foreign');
		});
		Schema::table('customers', function(Blueprint $table) {
			$table->dropForeign('customers_country_id_foreign');
		});
	}
}