<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMediaTable extends Migration {

	public function up()
	{
		Schema::create('media', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->enum('type', array('audio', 'video'));
			$table->string('title');
			$table->string('description');
		});
	}

	public function down()
	{
		Schema::drop('media');
	}
}