<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Eloquent\Model;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('blog_posts', function(Blueprint $table) {
			$table->foreign('catogery_id')->references('id')->on('blog_categories')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('blog_posts', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('blog_posts', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('city')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('places', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('city')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('place_type', function(Blueprint $table) {
			$table->foreign('place_id')->references('id')->on('places')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('country', function(Blueprint $table) {
			$table->foreign('continent_id')->references('id')->on('country')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('city', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('country')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('comment_reviews', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('media', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('blog_posts', function(Blueprint $table) {
			$table->dropForeign('blog_posts_catogery_id_foreign');
		});
		Schema::table('blog_posts', function(Blueprint $table) {
			$table->dropForeign('blog_posts_user_id_foreign');
		});
		Schema::table('blog_posts', function(Blueprint $table) {
			$table->dropForeign('blog_posts_city_id_foreign');
		});
		Schema::table('places', function(Blueprint $table) {
			$table->dropForeign('places_city_id_foreign');
		});
		Schema::table('place_type', function(Blueprint $table) {
			$table->dropForeign('place_type_place_id_foreign');
		});
		Schema::table('country', function(Blueprint $table) {
			$table->dropForeign('country_continent_id_foreign');
		});
		Schema::table('city', function(Blueprint $table) {
			$table->dropForeign('city_city_id_foreign');
		});
		Schema::table('comment_reviews', function(Blueprint $table) {
			$table->dropForeign('comment_reviews_user_id_foreign');
		});
		Schema::table('media', function(Blueprint $table) {
			$table->dropForeign('media_user_id_foreign');
		});
	}
}