<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->integer('user_id')->unsigned();
			$table->date('delivery_date')->index();
			$table->float('order_value');
			$table->tinyInteger('order_status')->unsigned()->index();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}