<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Meal extends Model 
{

    protected $table = 'meals';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('menu', 'title', 'description', 'calories', 'carbohydrates', 'protein', 'fat', 'allergens', 'status');

    public function inOrders()
    {
        return $this->belongsTo('OrderMeal');
    }

    public function image()
    {
        return $this->hasOne('Image');
    }

    public function thumbnail()
    {
        return $this->hasOne('Image');
    }

}