<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTicketAvailabilitiesTable extends Migration {

	public function up()
	{
		Schema::create('ticket_availabilities', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('trip_id')->unsigned();
			$table->integer('seat_class_id')->unsigned();
			$table->integer('ticket_class_id')->unsigned();
			$table->integer('cabin_type_id')->unsigned()->nullable();
			$table->integer('pax')->nullable();
			$table->integer('seat_from')->nullable();
			$table->integer('seat_to')->nullable();
			$table->decimal('price_one_way', 8,2)->nullable();
			$table->decimal('price_two_way', 8,2)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('ticket_availabilities');
	}
}