<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('vessels', function(Blueprint $table) {
			$table->foreign('vessel_model_id')->references('id')->on('vessel_models')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('vessels', function(Blueprint $table) {
			$table->foreign('created_by')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('vessel_cabins_counts', function(Blueprint $table) {
			$table->foreign('cabin_type_id')->references('id')->on('cabin_types')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('vessel_cabins_counts', function(Blueprint $table) {
			$table->foreign('seat_class_id')->references('id')->on('seat_classes')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('vessel_cabins_counts', function(Blueprint $table) {
			$table->foreign('vessel_id')->references('id')->on('vessels')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('liens', function(Blueprint $table) {
			$table->foreign('vessel_id')->references('id')->on('vessels')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('routes', function(Blueprint $table) {
			$table->foreign('from')->references('id')->on('ports')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('routes', function(Blueprint $table) {
			$table->foreign('to')->references('id')->on('ports')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('ports', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('trips', function(Blueprint $table) {
			$table->foreign('route_id')->references('id')->on('routes')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('trips', function(Blueprint $table) {
			$table->foreign('vessel_id')->references('id')->on('vessels')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('ticket_availabilities', function(Blueprint $table) {
			$table->foreign('trip_id')->references('id')->on('trips')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('ticket_availabilities', function(Blueprint $table) {
			$table->foreign('seat_class_id')->references('id')->on('seat_classes')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('ticket_availabilities', function(Blueprint $table) {
			$table->foreign('ticket_class_id')->references('id')->on('ticket_classes')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('ticket_availabilities', function(Blueprint $table) {
			$table->foreign('cabin_type_id')->references('id')->on('cabin_types')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->foreign('client_id')->references('id')->on('clients')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('vessel_routes', function(Blueprint $table) {
			$table->foreign('route_id')->references('id')->on('routes')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('vessel_routes', function(Blueprint $table) {
			$table->foreign('vessel_id')->references('id')->on('vessels')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('vessels_trans', function(Blueprint $table) {
			$table->foreign('vessel_id')->references('id')->on('vessels')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('seat_classes_trans', function(Blueprint $table) {
			$table->foreign('seat_class_id')->references('id')->on('seat_classes')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('cabin_types_trans', function(Blueprint $table) {
			$table->foreign('cabin_type_id')->references('id')->on('cabin_types')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('ports_trans', function(Blueprint $table) {
			$table->foreign('port_id')->references('id')->on('ports')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('vessel_models_trans', function(Blueprint $table) {
			$table->foreign('vessel_model_id')->references('id')->on('vessel_models')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('ticket_classes_trans', function(Blueprint $table) {
			$table->foreign('ticket_class_id')->references('id')->on('ticket_classes')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('countries_trans', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('countries')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('currencies_trans', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currencies')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('ticket_policies', function(Blueprint $table) {
			$table->foreign('ticket_class_id')->references('id')->on('ticket_classes')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('vessels', function(Blueprint $table) {
			$table->dropForeign('vessels_vessel_model_id_foreign');
		});
		Schema::table('vessels', function(Blueprint $table) {
			$table->dropForeign('vessels_created_by_foreign');
		});
		Schema::table('vessel_cabins_counts', function(Blueprint $table) {
			$table->dropForeign('vessel_cabins_counts_cabin_type_id_foreign');
		});
		Schema::table('vessel_cabins_counts', function(Blueprint $table) {
			$table->dropForeign('vessel_cabins_counts_seat_class_id_foreign');
		});
		Schema::table('vessel_cabins_counts', function(Blueprint $table) {
			$table->dropForeign('vessel_cabins_counts_vessel_id_foreign');
		});
		Schema::table('liens', function(Blueprint $table) {
			$table->dropForeign('liens_vessel_id_foreign');
		});
		Schema::table('routes', function(Blueprint $table) {
			$table->dropForeign('routes_from_foreign');
		});
		Schema::table('routes', function(Blueprint $table) {
			$table->dropForeign('routes_to_foreign');
		});
		Schema::table('ports', function(Blueprint $table) {
			$table->dropForeign('ports_country_id_foreign');
		});
		Schema::table('trips', function(Blueprint $table) {
			$table->dropForeign('trips_route_id_foreign');
		});
		Schema::table('trips', function(Blueprint $table) {
			$table->dropForeign('trips_vessel_id_foreign');
		});
		Schema::table('ticket_availabilities', function(Blueprint $table) {
			$table->dropForeign('ticket_availabilities_trip_id_foreign');
		});
		Schema::table('ticket_availabilities', function(Blueprint $table) {
			$table->dropForeign('ticket_availabilities_seat_class_id_foreign');
		});
		Schema::table('ticket_availabilities', function(Blueprint $table) {
			$table->dropForeign('ticket_availabilities_ticket_class_id_foreign');
		});
		Schema::table('ticket_availabilities', function(Blueprint $table) {
			$table->dropForeign('ticket_availabilities_cabin_type_id_foreign');
		});
		Schema::table('clients', function(Blueprint $table) {
			$table->dropForeign('clients_country_id_foreign');
		});
		Schema::table('transactions', function(Blueprint $table) {
			$table->dropForeign('transactions_client_id_foreign');
		});
		Schema::table('vessel_routes', function(Blueprint $table) {
			$table->dropForeign('vessel_routes_route_id_foreign');
		});
		Schema::table('vessel_routes', function(Blueprint $table) {
			$table->dropForeign('vessel_routes_vessel_id_foreign');
		});
		Schema::table('vessels_trans', function(Blueprint $table) {
			$table->dropForeign('vessels_trans_vessel_id_foreign');
		});
		Schema::table('seat_classes_trans', function(Blueprint $table) {
			$table->dropForeign('seat_classes_trans_seat_class_id_foreign');
		});
		Schema::table('cabin_types_trans', function(Blueprint $table) {
			$table->dropForeign('cabin_types_trans_cabin_type_id_foreign');
		});
		Schema::table('ports_trans', function(Blueprint $table) {
			$table->dropForeign('ports_trans_port_id_foreign');
		});
		Schema::table('vessel_models_trans', function(Blueprint $table) {
			$table->dropForeign('vessel_models_trans_vessel_model_id_foreign');
		});
		Schema::table('ticket_classes_trans', function(Blueprint $table) {
			$table->dropForeign('ticket_classes_trans_ticket_class_id_foreign');
		});
		Schema::table('countries_trans', function(Blueprint $table) {
			$table->dropForeign('countries_trans_country_id_foreign');
		});
		Schema::table('currencies_trans', function(Blueprint $table) {
			$table->dropForeign('currencies_trans_currency_id_foreign');
		});
		Schema::table('ticket_policies', function(Blueprint $table) {
			$table->dropForeign('ticket_policies_ticket_class_id_foreign');
		});
	}
}