<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePortsTable extends Migration {

	public function up()
	{
		Schema::create('ports', function(Blueprint $table) {
			$table->increments('id');
			$table->boolean('active')->default(0);
			$table->string('code', 255)->nullable();
			$table->integer('country_id')->unsigned()->nullable();
			$table->string('lat', 255)->nullable();
			$table->string('lng', 255)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('ports');
	}
}