<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateVesselsTable extends Migration {

	public function up()
	{
		Schema::create('vessels', function(Blueprint $table) {
			$table->increments('id')->primary();
			$table->string('vessel_number', 255)->unique()->nullable();
			$table->integer('width')->nullable();
			$table->mediumText('length')->nullable();
			$table->integer('speed')->nullable();
			$table->string('image', 255)->nullable();
			$table->integer('max_weight')->nullable();
			$table->integer('max_capacity')->nullable();
			$table->integer('max_passengers')->nullable();
			$table->integer('vessel_model_id')->unsigned();
			$table->enum('vessel_type', array('1', '2', '3'));
			$table->enum('grouping', array('yes', 'no'))->nullable();
			$table->integer('created_by')->unsigned();
			$table->timestamps();
			$table->timestamp('deleted_at');
		});
	}

	public function down()
	{
		Schema::drop('vessels');
	}
}