<?php

namespace App\Models;

class TicketAvailability extends Eloquent {

	protected $table = 'ticket_availabilities';
	public $timestamps = true;
	protected $fillable = array('trip_id', 'seat_class_id', 'ticket_class_id', 'pax', 'seat_from', 'seat_to');

	public function trip()
	{
		return $this->belongsTo('App\Models\Trip');
	}

	public function ticketClass()
	{
		return $this->belongsTo('App\Models\TicketClass');
	}

	public function seatClass()
	{
		return $this->belongsTo('App\Models\SeatClass');
	}

	public function cabinType()
	{
		return $this->belongsTo('App\Models\CabinType');
	}

}