<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFornecedoresTable extends Migration {

	public function up()
	{
		Schema::create('fornecedores', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('razao', 100);
			$table->string('nm_fantasia', 100);
			$table->string('endereco', 200);
			$table->string('cidade', 100);
			$table->text('estado');
			$table->text('cep');
			$table->string('telefone_1', 15);
			$table->string('telefone_2', 15);
			$table->string('nm_contato', 25);
			$table->string('cnpj', 14);
			$table->string('observacao', 250);
			$table->text('img_fornecedor');
			$table->integer('criado_por')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('fornecedores');
	}
}