<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('etablissement_user', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('etablissement_user', function(Blueprint $table) {
			$table->foreign('etablissement_id')->references('id')->on('etablissements')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('etablissement_user_role', function(Blueprint $table) {
			$table->foreign('etablissement_user_id')->references('id')->on('etablissement_user')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('etablissement_user_role', function(Blueprint $table) {
			$table->foreign('role_id')->references('id')->on('roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('etablissement_user', function(Blueprint $table) {
			$table->dropForeign('etablissement_user_user_id_foreign');
		});
		Schema::table('etablissement_user', function(Blueprint $table) {
			$table->dropForeign('etablissement_user_etablissement_id_foreign');
		});
		Schema::table('etablissement_user_role', function(Blueprint $table) {
			$table->dropForeign('etablissement_user_role_etablissement_user_id_foreign');
		});
		Schema::table('etablissement_user_role', function(Blueprint $table) {
			$table->dropForeign('etablissement_user_role_role_id_foreign');
		});
	}
}