<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCustomersTable extends Migration {

	public function up()
	{
		Schema::create('customers', function(Blueprint $table) {
			$table->increments('id');
			$table->string('number', 128);
			$table->tinyInteger('type');
			$table->tinyInteger('gender');
			$table->string('company', 128);
			$table->string('firstname', 128);
			$table->string('lastname', 128);
			$table->string('street', 128);
			$table->string('zip', 10);
			$table->string('city', 128);
			$table->string('country', 128);
			$table->tinyInteger('delivery_address');
			$table->string('delivery_company', 128);
			$table->string('delivery_firstname', 128);
			$table->string('delivery_lastname', 128);
			$table->string('delivery_street', 128);
			$table->string('delivery_zip', 10);
			$table->string('delivery_city', 128);
			$table->string('delivery_country', 128);
			$table->string('email', 128);
			$table->string('invoice_email', 128);
			$table->string('order_email', 128);
			$table->string('phone', 128);
			$table->string('mobile', 128);
			$table->string('tax_number', 128);
			$table->string('commercial_register', 128);
			$table->longText('note');
			$table->tinyInteger('state');
			$table->datetime('state_at');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('customers');
	}
}