<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrdersTable extends Migration {

	public function up()
	{
		Schema::create('orders', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('customer_id');
			$table->string('number', 128);
			$table->tinyInteger('type');
			$table->tinyInteger('gender');
			$table->string('company', 128);
			$table->string('firstname', 128);
			$table->string('lastname', 128);
			$table->string('street', 128);
			$table->string('zip', 10);
			$table->string('city', 128);
			$table->string('country', 128);
			$table->tinyInteger('delivery_address');
			$table->string('delivery_company', 128);
			$table->string('delivery_firstname', 128);
			$table->string('delivery_lastname', 128);
			$table->string('delivery_street', 128);
			$table->string('delivery_zip', 10);
			$table->string('delivery_city', 128);
			$table->string('delivery_country', 128);
			$table->string('email', 128);
			$table->string('invoice_email', 128);
			$table->string('order_email', 128);
			$table->string('delivery_email', 128);
			$table->string('tax_number', 128);
			$table->longText('customer_note');
			$table->string('commercial_register', 128);
			$table->string('note');
			$table->tinyInteger('delivery_type');
			$table->integer('payment_method_id');
			$table->tinyInteger('recurring');
			$table->string('recurring_interval', 128);
			$table->datetime('recurring_last');
			$table->datetime('recurring_next');
			$table->tinyInteger('state');
			$table->datetime('state_at');
			$table->decimal('price_with_tax');
			$table->decimal('price_without_tax');
			$table->decimal('tax');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('orders');
	}
}