<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePaymentsTable extends Migration {

	public function up()
	{
		Schema::create('payments', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('customer_id');
			$table->integer('order_id');
			$table->integer('invoice_id');
			$table->tinyInteger('type');
			$table->string('transaction_id', 255);
			$table->tinyInteger('state');
			$table->datetime('state_at');
			$table->decimal('paid_price');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('payments');
	}
}