<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderPositionsTable extends Migration {

	public function up()
	{
		Schema::create('order_positions', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('order_id');
			$table->integer('product_id');
			$table->integer('coupon_id');
			$table->string('name', 255);
			$table->integer('amount');
			$table->decimal('price_with_tax');
			$table->decimal('price_without_tax');
			$table->decimal('tax');
			$table->integer('tax_percent');
			$table->decimal('total_price_with_tax');
			$table->decimal('total_price_without_tax');
			$table->decimal('total_tax');
			$table->string('delivery_name', 255);
			$table->string('delivery_email', 128);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('order_positions');
	}
}