<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateInvoicePositionsTable extends Migration {

	public function up()
	{
		Schema::create('invoice_positions', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('invoice_id');
			$table->integer('product_id');
			$table->string('name', 255);
			$table->integer('amount');
			$table->decimal('price_with_tax');
			$table->decimal('price_without_tax');
			$table->decimal('tax');
			$table->integer('tax_percent');
			$table->decimal('total_price_with_tax');
			$table->decimal('total_price_without_tax');
			$table->decimal('total_tax');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('invoice_positions');
	}
}