<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCouponsTable extends Migration {

	public function up()
	{
		Schema::create('coupons', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('customer_id');
			$table->integer('order_id');
			$table->integer('order_position_id');
			$table->integer('product_id');
			$table->integer('huth_type');
			$table->string('number', 128);
			$table->decimal('balance');
			$table->datetime('balance_at');
			$table->tinyInteger('state');
			$table->datetime('state_at');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('coupons');
	}
}