<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Product extends Model 
{

    protected $table = 'products';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name_PT', 'name_EN', 'image', 'info_PT', 'info_EN', 'featured', 'product_type_id');

    public function productType()
    {
        return $this->belongsTo('ProductType', 'product_type_id');
    }

}