<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class ProductType extends Model 
{

    protected $table = 'product_types';
    public $timestamps = true;
    protected $fillable = array('name_PT', 'name_EN', 'product_model_id');

    public function products()
    {
        return $this->hasMany('Product', 'product_type_id');
    }

    public function productModel()
    {
        return $this->belongsTo('ProductModel', 'product_model_id');
    }

    public function productDrawings()
    {
        return $this->hasMany('ProductDrawing', 'product_type_id');
    }

}