<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDownloadsTable extends Migration {

	public function up()
	{
		Schema::create('downloads', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('title_pt', 256);
			$table->string('title_en', 256);
			$table->string('thumbnail', 256);
			$table->string('link', 512);
			$table->boolean('exclusive');
			$table->integer('download_type_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('downloads');
	}
}