<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductDrawingsTable extends Migration {

	public function up()
	{
		Schema::create('product_drawings', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 256);
			$table->integer('downloads');
			$table->string('file_2d', 512)->nullable();
			$table->string('file_3d', 512)->nullable();
			$table->integer('product_type_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('product_drawings');
	}
}