<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductsTable extends Migration {

	public function up()
	{
		Schema::create('products', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_PT', 256);
			$table->string('name_EN', 256);
			$table->string('image', 512);
			$table->text('info_PT')->default('Ainda não há informação disponível.');
			$table->string('info_EN', 512)->default('No information available yet.');
			$table->boolean('featured')->default(false);
			$table->integer('product_type_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('products');
	}
}