<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProductModelsTable extends Migration {

	public function up()
	{
		Schema::create('product_models', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name_PT', 256);
			$table->string('name_EN', 256);
			$table->string('image', 512)->nullable();
			$table->boolean('exclusive')->default(false);
			$table->integer('product_line_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('product_models');
	}
}