<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('sections', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('solutions', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('downloads', function(Blueprint $table) {
			$table->foreign('download_type_id')->references('id')->on('download_type')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('product_type_id')->references('id')->on('product_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_types', function(Blueprint $table) {
			$table->foreign('product_model_id')->references('id')->on('product_models')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_lines', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('product_lines', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('sections')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('product_drawings', function(Blueprint $table) {
			$table->foreign('product_type_id')->references('id')->on('product_types')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('product_models', function(Blueprint $table) {
			$table->foreign('product_line_id')->references('id')->on('product_lines')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sales_channels', function(Blueprint $table) {
			$table->foreign('city_and_region_id')->references('id')->on('cities_and_regions')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('cities_and_regions', function(Blueprint $table) {
			$table->foreign('state_id')->references('id')->on('states')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('news', function(Blueprint $table) {
			$table->foreign('image_id')->references('id')->on('images')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('news', function(Blueprint $table) {
			$table->foreign('language_id')->references('id')->on('languages')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('user_role_id')->references('id')->on('user_roles')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('city_and_region_id')->references('id')->on('cities_and_regions')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('user_logs', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('no action')
						->onUpdate('no action');
		});
		Schema::table('product_model_images', function(Blueprint $table) {
			$table->foreign('product_model_id')->references('id')->on('product_models')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('city_and_region_sales_channel', function(Blueprint $table) {
			$table->foreign('city_and_region_id')->references('id')->on('cities_and_regions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('city_and_region_sales_channel', function(Blueprint $table) {
			$table->foreign('sales_channel_id')->references('id')->on('sales_channels')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('sections', function(Blueprint $table) {
			$table->dropForeign('sections_language_id_foreign');
		});
		Schema::table('solutions', function(Blueprint $table) {
			$table->dropForeign('solutions_language_id_foreign');
		});
		Schema::table('downloads', function(Blueprint $table) {
			$table->dropForeign('downloads_download_type_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_product_type_id_foreign');
		});
		Schema::table('product_types', function(Blueprint $table) {
			$table->dropForeign('product_types_product_model_id_foreign');
		});
		Schema::table('product_lines', function(Blueprint $table) {
			$table->dropForeign('product_lines_category_id_foreign');
		});
		Schema::table('product_lines', function(Blueprint $table) {
			$table->dropForeign('product_lines_brand_id_foreign');
		});
		Schema::table('product_drawings', function(Blueprint $table) {
			$table->dropForeign('product_drawings_product_type_id_foreign');
		});
		Schema::table('product_models', function(Blueprint $table) {
			$table->dropForeign('product_models_product_line_id_foreign');
		});
		Schema::table('sales_channels', function(Blueprint $table) {
			$table->dropForeign('sales_channels_city_and_region_id_foreign');
		});
		Schema::table('cities_and_regions', function(Blueprint $table) {
			$table->dropForeign('cities_and_regions_state_id_foreign');
		});
		Schema::table('news', function(Blueprint $table) {
			$table->dropForeign('news_image_id_foreign');
		});
		Schema::table('news', function(Blueprint $table) {
			$table->dropForeign('news_language_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_user_role_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_city_and_region_id_foreign');
		});
		Schema::table('user_logs', function(Blueprint $table) {
			$table->dropForeign('user_logs_user_id_foreign');
		});
		Schema::table('product_model_images', function(Blueprint $table) {
			$table->dropForeign('product_model_images_product_model_id_foreign');
		});
		Schema::table('city_and_region_sales_channel', function(Blueprint $table) {
			$table->dropForeign('city_and_region_sales_channel_city_and_region_id_foreign');
		});
		Schema::table('city_and_region_sales_channel', function(Blueprint $table) {
			$table->dropForeign('city_and_region_sales_channel_sales_channel_id_foreign');
		});
	}
}