<?php

namespace App;

class CityRegion extends Eloquent {

	protected $table = 'cities_and_regions';
	public $timestamps = false;
	protected $fillable = array('name', 'state_id');

	public function salesChannels()
	{
		return $this->belongsToMany('SalesChannel', 'city_and_region_sales_channel', 'city_and_region_id', 'sales_channel_id');
	}

	public function state()
	{
		return $this->hasOne('State', 'state_id');
	}

}