<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class News extends Eloquent {

	protected $table = 'news';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('title', 'content', 'image_id', 'language_id');

	public function language()
	{
		return $this->belongsTo('Language', 'language_id');
	}

	public function image()
	{
		return $this->hasOne('Image', 'image_id');
	}

}