<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Product extends Eloquent {

	protected $table = 'products';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name_PT', 'name_EN', 'image', 'info_PT', 'info_EN', 'featured', 'product_type_id');

	public function productType()
	{
		return $this->belongsTo('ProductType', 'product_type_id');
	}

}