<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class ProductModelImage extends Eloquent {

	protected $table = 'product_model_images';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('image');

	public function productModels()
	{
		return $this->belongsTo('ProductModel', 'product_model_id');
	}

}