<?php

namespace App;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class SalesChannel extends Eloquent {

	protected $table = 'sales_channels';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('name', 'info', 'city_and_region_id');

	public function citiesAndRegions()
	{
		return $this->belongsTo('CityRegion', 'city_and_region_sales_channel', 'sales_channel_id', 'city_and_region_id');
	}

}