<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProductModelImage extends Model 
{

    protected $table = 'product_model_images';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('image');

    public function productModels()
    {
        return $this->belongsTo('ProductModel', 'product_model_id');
    }

}