<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProductDrawing extends Model 
{

    protected $table = 'product_drawings';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'downloads', 'file_2d', 'file_3d', 'product_type_id');

    public function productTypes()
    {
        return $this->belongsTo('ProductType', 'product_type_id');
    }

}