<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SalesChannel extends Model 
{

    protected $table = 'sales_channels';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('name', 'info', 'city_and_region_id');

    public function citiesAndRegions()
    {
        return $this->belongsTo('CityRegion', 'city_and_region_sales_channel', 'sales_channel_id', 'city_and_region_id');
    }

}