<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class UserLog extends Model 
{

    protected $table = 'user_logs';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('description', 'user_id');

    public function user()
    {
        return $this->belongsTo('User', 'user_id');
    }

}