<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateListingsTable extends Migration {

	public function up()
	{
		Schema::create('listings', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('currency_id')->unsigned();
			$table->integer('marketplace_id')->unsigned();
			$table->integer('product_abstraction_id')->unsigned();
			$table->decimal('price', 8,2);
			$table->integer('quantity_available');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('listings');
	}
}