<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectsTable extends Migration {

	public function up()
	{
		Schema::create('projects', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->text('description');
			$table->integer('appointment_id')->unsigned();
			$table->integer('cost_code_id')->unsigned();
			$table->integer('document_brief_id')->unsigned();
			$table->decimal('budget', 8,2);
			$table->timestamps();
			$table->softDeletes();
			$table->integer('document_plan_id')->unsigned();
			$table->integer('document_lessons_learned_id')->unsigned();
			$table->integer('document_closure_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('projects');
	}
}