<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('product_category_id')->references('id')->on('products_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products_categories', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('products_categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products_variations', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('products_variations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products_variations', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products_instances', function(Blueprint $table) {
			$table->foreign('product_variation_id')->references('id')->on('products_variations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products_identifiers', function(Blueprint $table) {
			$table->foreign('product_abstraction_id')->references('id')->on('products_abstractions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products_identifiers', function(Blueprint $table) {
			$table->foreign('product_identifier_type_id')->references('id')->on('products_instances')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products_identifiers_types', function(Blueprint $table) {
			$table->foreign('person_id')->references('id')->on('person')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('listings', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currencies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('listings', function(Blueprint $table) {
			$table->foreign('marketplace_id')->references('id')->on('marketplaces')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('listings', function(Blueprint $table) {
			$table->foreign('product_abstraction_id')->references('id')->on('products_abstractions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('marketplaces', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('marketplaces')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('marketplaces', function(Blueprint $table) {
			$table->foreign('person_id')->references('id')->on('person')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products_attributes_values', function(Blueprint $table) {
			$table->foreign('product_attribute_id')->references('id')->on('products_allowed_attributes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products_attributes_values', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('products_attributes_values')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products_allowed_attributes', function(Blueprint $table) {
			$table->foreign('product_abstraction_id')->references('id')->on('products_abstractions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products_allowed_attributes', function(Blueprint $table) {
			$table->foreign('product_allowed_attribute_id')->references('id')->on('products_allowed_attributes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products_allowed_attributes_values', function(Blueprint $table) {
			$table->foreign('product_abstraction_id')->references('id')->on('products_abstractions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products_allowed_attributes_values', function(Blueprint $table) {
			$table->foreign('product_attribute_value_id')->references('id')->on('products_allowed_attributes_values')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products_actual_attribute_values', function(Blueprint $table) {
			$table->foreign('product_abstraction_id')->references('id')->on('products_abstractions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('products_actual_attribute_values', function(Blueprint $table) {
			$table->foreign('product_attribute_value_id')->references('id')->on('products_attributes_values')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('stock', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('stock', function(Blueprint $table) {
			$table->foreign('products_abstraction_id')->references('id')->on('products_abstractions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('locations', function(Blueprint $table) {
			$table->foreign('parent_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lines', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currencies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lines', function(Blueprint $table) {
			$table->foreign('listing_id')->references('id')->on('listings')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('lines', function(Blueprint $table) {
			$table->foreign('product_abstraction_id')->references('id')->on('products_abstractions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('person')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->foreign('supplier_id')->references('id')->on('person')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->foreign('accepted_by_person_id')->references('id')->on('person')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->foreign('cancelled_by_person_id')->references('id')->on('person')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('delivery', function(Blueprint $table) {
			$table->foreign('courier_id')->references('id')->on('person')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('delivery', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('person')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('delivery', function(Blueprint $table) {
			$table->foreign('supplier_id')->references('id')->on('person')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('delivery', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('order')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoice', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currencies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoice', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('person')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoice', function(Blueprint $table) {
			$table->foreign('supplier_id')->references('id')->on('person')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoice', function(Blueprint $table) {
			$table->foreign('financial_period_id')->references('id')->on('financial_periods')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('settlement', function(Blueprint $table) {
			$table->foreign('bank_account_from_id')->references('id')->on('bank_account')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('settlement', function(Blueprint $table) {
			$table->foreign('bank_account_to_id')->references('id')->on('bank_account')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('settlement', function(Blueprint $table) {
			$table->foreign('currency_id')->references('id')->on('currencies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('settlement', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('person')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('settlement', function(Blueprint $table) {
			$table->foreign('supplier_id')->references('id')->on('person')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('quotes', function(Blueprint $table) {
			$table->foreign('customer_id')->references('id')->on('person')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('quotes', function(Blueprint $table) {
			$table->foreign('supplier_id')->references('id')->on('person')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('bank_account', function(Blueprint $table) {
			$table->foreign('person_id')->references('id')->on('person')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoices_reconciliations', function(Blueprint $table) {
			$table->foreign('invoice_id')->references('id')->on('invoice')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoices_reconciliations', function(Blueprint $table) {
			$table->foreign('settlement_id')->references('id')->on('settlement')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoices_reconciliations', function(Blueprint $table) {
			$table->foreign('invoice_currency_id')->references('id')->on('currencies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('invoices_reconciliations', function(Blueprint $table) {
			$table->foreign('settlement_currency_Id')->references('id')->on('currencies')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->foreign('position_id')->references('id')->on('positions')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->foreign('person_id')->references('id')->on('person')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('positions', function(Blueprint $table) {
			$table->foreign('job_id')->references('id')->on('jobs')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('positions', function(Blueprint $table) {
			$table->foreign('location_id')->references('id')->on('locations')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('positions', function(Blueprint $table) {
			$table->foreign('team_id')->references('id')->on('teams')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sickness', function(Blueprint $table) {
			$table->foreign('appointment_id')->references('id')->on('appointments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sickness', function(Blueprint $table) {
			$table->foreign('approver_id')->references('id')->on('appointments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('holidays', function(Blueprint $table) {
			$table->foreign('appointment_id')->references('id')->on('appointments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('holidays', function(Blueprint $table) {
			$table->foreign('approver_id')->references('id')->on('appointments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('pay_rates', function(Blueprint $table) {
			$table->foreign('appointment_id')->references('id')->on('appointments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('appointments_contracts', function(Blueprint $table) {
			$table->foreign('appointment_id')->references('id')->on('appointments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('appointments_contracts', function(Blueprint $table) {
			$table->foreign('contract_id')->references('id')->on('contracts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('timesheets', function(Blueprint $table) {
			$table->foreign('appointment_id')->references('id')->on('appointments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('timesheets', function(Blueprint $table) {
			$table->foreign('gross_pay_id')->references('id')->on('appointments_gross_pay')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('timesheets', function(Blueprint $table) {
			$table->foreign('project_id')->references('id')->on('projects')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('timesheets', function(Blueprint $table) {
			$table->foreign('process_id')->references('id')->on('processes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('appointment_id')->references('id')->on('appointments_contracts')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('cost_code_id')->references('id')->on('cost_codes')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('document_plan_id')->references('id')->on('documents')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('document_lessons_learned_id')->references('id')->on('documents')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->foreign('document_closure_id')->references('id')->on('documents')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('appointments_gross_pay', function(Blueprint $table) {
			$table->foreign('appointment_id')->references('id')->on('appointments')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('appointments_gross_pay', function(Blueprint $table) {
			$table->foreign('financial_period_id')->references('id')->on('financial_periods')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_parent_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_product_category_id_foreign');
		});
		Schema::table('products_categories', function(Blueprint $table) {
			$table->dropForeign('products_categories_parent_id_foreign');
		});
		Schema::table('products_variations', function(Blueprint $table) {
			$table->dropForeign('products_variations_parent_id_foreign');
		});
		Schema::table('products_variations', function(Blueprint $table) {
			$table->dropForeign('products_variations_product_id_foreign');
		});
		Schema::table('products_instances', function(Blueprint $table) {
			$table->dropForeign('products_instances_product_variation_id_foreign');
		});
		Schema::table('products_identifiers', function(Blueprint $table) {
			$table->dropForeign('products_identifiers_product_abstraction_id_foreign');
		});
		Schema::table('products_identifiers', function(Blueprint $table) {
			$table->dropForeign('products_identifiers_product_identifier_type_id_foreign');
		});
		Schema::table('products_identifiers_types', function(Blueprint $table) {
			$table->dropForeign('products_identifiers_types_person_id_foreign');
		});
		Schema::table('listings', function(Blueprint $table) {
			$table->dropForeign('listings_currency_id_foreign');
		});
		Schema::table('listings', function(Blueprint $table) {
			$table->dropForeign('listings_marketplace_id_foreign');
		});
		Schema::table('listings', function(Blueprint $table) {
			$table->dropForeign('listings_product_abstraction_id_foreign');
		});
		Schema::table('marketplaces', function(Blueprint $table) {
			$table->dropForeign('marketplaces_parent_id_foreign');
		});
		Schema::table('marketplaces', function(Blueprint $table) {
			$table->dropForeign('marketplaces_person_id_foreign');
		});
		Schema::table('products_attributes_values', function(Blueprint $table) {
			$table->dropForeign('products_attributes_values_product_attribute_id_foreign');
		});
		Schema::table('products_attributes_values', function(Blueprint $table) {
			$table->dropForeign('products_attributes_values_parent_id_foreign');
		});
		Schema::table('products_allowed_attributes', function(Blueprint $table) {
			$table->dropForeign('products_allowed_attributes_product_abstraction_id_foreign');
		});
		Schema::table('products_allowed_attributes', function(Blueprint $table) {
			$table->dropForeign('products_allowed_attributes_product_allowed_attribute_id_foreign');
		});
		Schema::table('products_allowed_attributes_values', function(Blueprint $table) {
			$table->dropForeign('products_allowed_attributes_values_product_abstraction_id_foreign');
		});
		Schema::table('products_allowed_attributes_values', function(Blueprint $table) {
			$table->dropForeign('products_allowed_attributes_values_product_attribute_value_id_foreign');
		});
		Schema::table('products_actual_attribute_values', function(Blueprint $table) {
			$table->dropForeign('products_actual_attribute_values_product_abstraction_id_foreign');
		});
		Schema::table('products_actual_attribute_values', function(Blueprint $table) {
			$table->dropForeign('products_actual_attribute_values_product_attribute_value_id_foreign');
		});
		Schema::table('stock', function(Blueprint $table) {
			$table->dropForeign('stock_location_id_foreign');
		});
		Schema::table('stock', function(Blueprint $table) {
			$table->dropForeign('stock_products_abstraction_id_foreign');
		});
		Schema::table('locations', function(Blueprint $table) {
			$table->dropForeign('locations_parent_id_foreign');
		});
		Schema::table('lines', function(Blueprint $table) {
			$table->dropForeign('lines_currency_id_foreign');
		});
		Schema::table('lines', function(Blueprint $table) {
			$table->dropForeign('lines_listing_id_foreign');
		});
		Schema::table('lines', function(Blueprint $table) {
			$table->dropForeign('lines_product_abstraction_id_foreign');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->dropForeign('order_customer_id_foreign');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->dropForeign('order_supplier_id_foreign');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->dropForeign('order_accepted_by_person_id_foreign');
		});
		Schema::table('order', function(Blueprint $table) {
			$table->dropForeign('order_cancelled_by_person_id_foreign');
		});
		Schema::table('delivery', function(Blueprint $table) {
			$table->dropForeign('delivery_courier_id_foreign');
		});
		Schema::table('delivery', function(Blueprint $table) {
			$table->dropForeign('delivery_customer_id_foreign');
		});
		Schema::table('delivery', function(Blueprint $table) {
			$table->dropForeign('delivery_supplier_id_foreign');
		});
		Schema::table('delivery', function(Blueprint $table) {
			$table->dropForeign('delivery_order_id_foreign');
		});
		Schema::table('invoice', function(Blueprint $table) {
			$table->dropForeign('invoice_currency_id_foreign');
		});
		Schema::table('invoice', function(Blueprint $table) {
			$table->dropForeign('invoice_customer_id_foreign');
		});
		Schema::table('invoice', function(Blueprint $table) {
			$table->dropForeign('invoice_supplier_id_foreign');
		});
		Schema::table('invoice', function(Blueprint $table) {
			$table->dropForeign('invoice_financial_period_id_foreign');
		});
		Schema::table('settlement', function(Blueprint $table) {
			$table->dropForeign('settlement_bank_account_from_id_foreign');
		});
		Schema::table('settlement', function(Blueprint $table) {
			$table->dropForeign('settlement_bank_account_to_id_foreign');
		});
		Schema::table('settlement', function(Blueprint $table) {
			$table->dropForeign('settlement_currency_id_foreign');
		});
		Schema::table('settlement', function(Blueprint $table) {
			$table->dropForeign('settlement_customer_id_foreign');
		});
		Schema::table('settlement', function(Blueprint $table) {
			$table->dropForeign('settlement_supplier_id_foreign');
		});
		Schema::table('quotes', function(Blueprint $table) {
			$table->dropForeign('quotes_customer_id_foreign');
		});
		Schema::table('quotes', function(Blueprint $table) {
			$table->dropForeign('quotes_supplier_id_foreign');
		});
		Schema::table('bank_account', function(Blueprint $table) {
			$table->dropForeign('bank_account_person_id_foreign');
		});
		Schema::table('invoices_reconciliations', function(Blueprint $table) {
			$table->dropForeign('invoices_reconciliations_invoice_id_foreign');
		});
		Schema::table('invoices_reconciliations', function(Blueprint $table) {
			$table->dropForeign('invoices_reconciliations_settlement_id_foreign');
		});
		Schema::table('invoices_reconciliations', function(Blueprint $table) {
			$table->dropForeign('invoices_reconciliations_invoice_currency_id_foreign');
		});
		Schema::table('invoices_reconciliations', function(Blueprint $table) {
			$table->dropForeign('invoices_reconciliations_settlement_currency_Id_foreign');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->dropForeign('appointments_position_id_foreign');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->dropForeign('appointments_person_id_foreign');
		});
		Schema::table('positions', function(Blueprint $table) {
			$table->dropForeign('positions_job_id_foreign');
		});
		Schema::table('positions', function(Blueprint $table) {
			$table->dropForeign('positions_location_id_foreign');
		});
		Schema::table('positions', function(Blueprint $table) {
			$table->dropForeign('positions_team_id_foreign');
		});
		Schema::table('sickness', function(Blueprint $table) {
			$table->dropForeign('sickness_appointment_id_foreign');
		});
		Schema::table('sickness', function(Blueprint $table) {
			$table->dropForeign('sickness_approver_id_foreign');
		});
		Schema::table('holidays', function(Blueprint $table) {
			$table->dropForeign('holidays_appointment_id_foreign');
		});
		Schema::table('holidays', function(Blueprint $table) {
			$table->dropForeign('holidays_approver_id_foreign');
		});
		Schema::table('pay_rates', function(Blueprint $table) {
			$table->dropForeign('pay_rates_appointment_id_foreign');
		});
		Schema::table('appointments_contracts', function(Blueprint $table) {
			$table->dropForeign('appointments_contracts_appointment_id_foreign');
		});
		Schema::table('appointments_contracts', function(Blueprint $table) {
			$table->dropForeign('appointments_contracts_contract_id_foreign');
		});
		Schema::table('timesheets', function(Blueprint $table) {
			$table->dropForeign('timesheets_appointment_id_foreign');
		});
		Schema::table('timesheets', function(Blueprint $table) {
			$table->dropForeign('timesheets_gross_pay_id_foreign');
		});
		Schema::table('timesheets', function(Blueprint $table) {
			$table->dropForeign('timesheets_project_id_foreign');
		});
		Schema::table('timesheets', function(Blueprint $table) {
			$table->dropForeign('timesheets_process_id_foreign');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_appointment_id_foreign');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_cost_code_id_foreign');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_document_plan_id_foreign');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_document_lessons_learned_id_foreign');
		});
		Schema::table('projects', function(Blueprint $table) {
			$table->dropForeign('projects_document_closure_id_foreign');
		});
		Schema::table('appointments_gross_pay', function(Blueprint $table) {
			$table->dropForeign('appointments_gross_pay_appointment_id_foreign');
		});
		Schema::table('appointments_gross_pay', function(Blueprint $table) {
			$table->dropForeign('appointments_gross_pay_financial_period_id_foreign');
		});
	}
}