<?php

namespace App\Models\HR;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class AppointmentGrossPay extends Eloquent {

	protected $table = 'appointments_gross_pay';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function appointment()
	{
		return $this->belongsTo('App\Models\HR\Appointment', 'appointment_id');
	}

	public function financial_period()
	{
		return $this->belongsTo('App\Models\Finance\FinancialPeriod', 'financial_period_id');
	}

}