<?php

namespace App\Models\Finance;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class InvoiceReconciliation extends Eloquent {

	protected $table = 'invoices_reconciliations';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function invoice()
	{
		return $this->belongsTo('App\Models\Finance\Invoice', 'invoice_id');
	}

	public function settlement()
	{
		return $this->belongsTo('App\Models\Finance\Settlement', 'settlement_id');
	}

	public function invoice_currency()
	{
		return $this->belongsTo('App\Models\Finance\Currency', 'invoice_currency_id');
	}

	public function settlement_currency()
	{
		return $this->belongsTo('App\Models\Finance\Currency', 'settlement_currency_id');
	}

}