<?php

namespace App\Models\HR;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Sickness extends Eloquent {

	protected $table = 'sickness';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function appointment()
	{
		return $this->belongsTo('App\Models\HR\Appointment', 'appointment_id');
	}

	public function approver()
	{
		return $this->belongsTo('App\Models\HR\Appointment', 'approver_id');
	}

}