<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDeliveryTable extends Migration {

	public function up()
	{
		Schema::create('delivery', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('courier_id')->unsigned();
			$table->integer('customer_id')->unsigned();
			$table->integer('supplier_id')->unsigned();
			$table->string('courier_tracking_number', 255);
			$table->datetimeTz('datetime_courier_delivery');
			$table->date('date_actual')->nullable();
			$table->date('date_expected')->nullable();
			$table->decimal('quantity_total', 8,4);
			$table->timestamps();
			$table->softDeletes();
			$table->integer('order_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('delivery');
	}
}